function pricing() {
  return {
    activeService: 'website',
    billPlan: 'monthly',

    services: {
      website: {
        label: 'Website',
        type: 'one-time',
        plans: [
          {
            name: 'Simple Website',
            price: '₹8,999',
            features: [
              '5 Pages (Portfolio / Business)',
              'Responsive Design',
              'Fast Loading',
              'Basic SEO',
              'Contact Form',
              'Static Website'
            ]
          },
          {
            name: 'Modern Website',
            price: '₹18,999',
            features: [
              'Modern UI/UX',
              'Dynamic Content / CMS',
              'Email Form Submission (SMTP)',
              'Google Map Integration',
              'SEO Friendly Structure',
              '1 Month Support'
            ]
          },
          {
            name: 'Dynamic Website (E-Commerce)',
            price: '₹39,999+',
            features: [
              'Product / Service Management',
              'Payment Gateway Integration',
              'Order Management',
              'Admin Dashboard',
              'Secure Login System',
              '3 Months Support'
            ]
          }
        ]
      },

      app: {
        label: 'App',
        type: 'one-time',
        plans: [
          {
            name: 'Basic App',
            price: 'Starts ₹49,999',
            features: [
              'Android App',
              'Static Pages',
              'Contact / Enquiry Form',
              'Play Store Ready',
              'Basic Admin Panel'
            ]
          },
          {
            name: 'Dynamic App',
            price: 'Starts ₹79,999',
            features: [
              'Android / iOS',
              'User Login / Signup',
              'Dynamic Content',
              'API Integration',
              'Push Notifications'
            ]
          },
          {
            name: 'Advanced App',
            price: 'Starts ₹1,49,999',
            features: [
              'Android + iOS',
              'Payment Gateway',
              'Admin Dashboard',
              'Real-time Data',
              'Scalable Architecture'
            ]
          }
        ]
      },

      email: {
        label: 'Email',
        type: 'recurring',
        plans: [
          {
            name: 'Simple Emailer',
            price: { monthly: 2999, annually: 29999 },
            features: [
              '2 HTML Email Designs',
              'Mobile Responsive',
              'CTA Button',
              'Basic Analytics'
            ]
          },
          {
            name: 'Email + Landing Page',
            price: { monthly: 5999, annually: 59999 },
            features: [
              '4 Email Templates',
              'Custom Landing Page',
              'Lead Form Integration',
              'Email Submission Setup'
            ]
          },
          {
            name: 'Email Automation',
            price: { monthly: 9999, annually: 99999 },
            features: [
              '8 Email Campaigns',
              'Automation Workflow',
              'Lead Segmentation',
              'Performance Report'
            ]
          }
        ]
      },

      social: {
        label: 'Social Media',
        type: 'recurring',
        plans: [
          {
            name: 'Starter Plan',
            price: { monthly: 3999, annually: 39999 },
            features: [
              '8 Creative Posts',
              'Captions + Hashtags',
              'Brand Color Theme'
            ]
          },
          {
            name: 'Growth Plan',
            price: { monthly: 7999, annually: 79999 },
            features: [
              '12 Posts',
              '6 Reels / Shorts',
              'Content Strategy'
            ]
          },
          {
            name: 'Premium Plan',
            price: { monthly: 12999, annually: 129999 },
            features: [
              '20 Posts',
              '10 Reels',
              'Paid Ads Strategy',
              'Monthly Analytics'
            ]
          }
        ]
      },

      seo: {
        label: 'SEO',
        type: 'recurring',
        plans: [
          {
            name: 'Basic SEO',
            price: { monthly: 5999, annually: 59999 },
            features: [
              'On-Page SEO',
              'Keyword Research',
              'Google Search Console',
              'Monthly Report'
            ]
          },
          {
            name: 'Growth SEO',
            price: { monthly: 9999, annually: 99999 },
            features: [
              'Content Optimization',
              'Technical SEO',
              'Link Building',
              'Competitor Analysis'
            ]
          },
          {
            name: 'Advanced SEO',
            price: { monthly: 14999, annually: 149999 },
            features: [
              'Authority Backlinks',
              'Conversion Optimization',
              'Blog Strategy',
              'Ranking Tracking'
            ]
          }
        ]
      },

      branding: {
        label: 'Branding',
        type: 'one-time',
        plans: [
          {
            name: 'Basic Branding',
            price: '₹4,999',
            features: [
              'Logo Design',
              'Brand Colors',
              'Typography'
            ]
          },
          {
            name: 'Brand Identity',
            price: '₹9,999',
            features: [
              'Logo + Social Kit',
              'Visiting Card',
              'Brand Guidelines'
            ]
          },
          {
            name: 'Complete Brand Kit',
            price: '₹19,999',
            features: [
              'Full Brand Identity',
              'Marketing Creatives',
              'Social Media Templates'
            ]
          }
        ]
      }
    }
  }
}





